\name{bpafromdist}
\alias{dsadf}
\alias{dsodf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Construct pboxes}
\description{
Methods to construct pboxes from distributions.
}
\usage{
dsadf(fhandle, intervalnumber, ...)
dsodf(fhandle, intervalnumber, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fhandle}{Inverse CDF function (e. g. qnorm)}
  \item{intervalnumber}{Number of intervals of the resulting BPA}
  \item{\dots}{Parameters (either points or BPAs) for fhandle}
}
\details{
\itemize{
\item \code{dsadf} average discretization method
\item \code{dsodf} outer discretization method (conservative regarding the discretization error)
}
The IPP Toolbox contains two methods to construct pboxes from distributions. The functions dsadf (average discetization method) and dsodf (outer discretization method) are used to sample a set of focal element from a parametric model. The parametric model must be given as an inverse cdf F-1(x) with precise or imprecise parameters. Both methods sample the provided inverse CDF function F-1(x) to generate a set of focal elements. dsadf samples points, e.g. 0.05, 0.15, 0.25,..., 0.95, while dsodf samples intervals, e.g. [0,0.1], [0.1,0.2],..., [0.9,1]. A BPA constructed by dsodf is more conservative and includes a BPA generated by dsadf.

The example generates several pboxes from normal distributions. It illustrates the difference of dsadf and dsodf by plotting BPAs with precise parameters of only 20 samples (pbox1, pbox2). Then it generates two pboxes with imprecise parameters.}
\value{
BPA representing a pbox sampled from fhandle.
}
\references{Tonon, F. (2004). "Using random set theory to propagate epistemic uncertainty through a mechanical system." Reliability Engineering and System Safety 85(1-3): 169-181.}
\author{Philipp Limbourg <p.limbourg@uni-due.de>}
\examples{
print("Precise and imprecise parameters for qnorm")
mu=0; sigma=1
mu2=dsstruct(c(-0.5,0.5,1)); sigma2=dsstruct(c(1,2,1))
print("Pbox (distribution) of qnorm with precise parameters:")
pbox1=dsadf(qnorm,20,mu,sigma)
dscdf(pbox1)

print("Pbox of qnorm with precise parameters, outer discretization:")
pbox2=dsodf(qnorm,20,mu,sigma)
dscdf(pbox2)

print("Pbox of qnorm with imprecise mu, precise sigma:")
pbox3=dsodf(qnorm,1000,mu2,sigma)
dscdf(pbox3)

print("Pbox of qnorm with imprecise parameters:")
pbox4=dsodf(qnorm,1000,mu2,sigma2)
dscdf(pbox4)
}