% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eviction.R
\name{truncated_distributions}
\alias{truncated_distributions}
\alias{discrete_extrema}
\title{Eviction correction}
\usage{
truncated_distributions(fun, target, ...)

discrete_extrema(target, state, ncol = NULL, nrow = NULL)
}
\arguments{
\item{fun}{The density function to use. For example, could be
\code{"norm"} to correct a Gaussian density function, or \code{"lnorm"} to
correct a log-normal density function.}

\item{target}{The parameter/vital rate being modified. If this is a vector, the
distribution specified in \code{fun} will be recycled.}

\item{...}{Used internally, do not touch!}

\item{state}{The state variable used in the kernel that is being discretized.}

\item{ncol, nrow}{The number of rows or column that the final form of the iteration
matrix should have. This is only necessary for rectangular kernels with
class \code{"CC"}. \code{make_ipm} works out the correct dimensions for
\code{"DC"} and \code{"CD"} kernels internally.}
}
\value{
For \code{truncated_distributions}, a
modified function call with that truncates the probability density
function based on the cumulative density function.

For \code{discrete_extrema}, a numeric vector with modified entries based
on the discretization process.
}
\description{
Various helpers to correct for unintentional eviction (Williams
et al. 2012).
}
\note{
Neither of these functions are intended for use outside of
\code{define_kernel}, as they rely on internally generated variables to
work inside of \code{make_ipm}.
}
\references{
Williams JL, Miller TEX & Ellner SP, (2012). Avoiding unintentional eviction
from integral projection models.Ecology 93(9): 2008-2014.
}
