% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_excl_step.R
\encoding{utf-8}
\name{ind_excl_step}
\alias{ind_excl_step}
\title{One step in indicator exclusion procedure}
\usage{
ind_excl_step(indicators, outcome, indicatornames = 1:ncol(indicators),
  exclude = vector(), coruse = "everything", round = F)
}
\arguments{
\item{indicators}{Set of numeric indicators (items) in a matrix.}

\item{outcome}{A numeric outcome vector. Indicators and outcome can be simulated with
\code{\link{scale_sim}}}

\item{indicatornames}{An array of strings for labelling the outcome. Default to numbers
from 1 to n of indicators}

\item{exclude}{Exclude an item excluded at previous step, e.g., as decided by \code{\link{ind_excl_inc}}}

\item{coruse}{argument for function cor(). Defaults to 'everything', as
simulations have no missing data.}

\item{round}{Allows rounding of values in returned matrix.}
}
\value{
Provides the results of a single step in indicator exclusion procedure. See example for
details
}
\description{
See \code{\link{ind_excl}} for details.
}
\examples{
## Create a scale-outcome set that violates ION. Only 2 indicators out of 8 relate to
## the outcome, the others just relate to the 2 indicators
set.seed(466)
a<-scale_sim(n=2500, to_n=2, tn_n=6)
res=ind_excl_step(a[[1]],a[[2]])
print(res)

# note that the p-values for upper items (7 & 8 ) are much smaller than for the rest

#row number   indicator number
#r.test.t     t value of the r.test.
#t.test.p     p value of the r.test.
#cor_excl     correlation between outcome and sum-score when an item is excluded.
#cor_all      correlation between outcome and sum-score when all items are included
# (i.e., full scale).
#cor.excl_all correlation between two sum-scores.
}

