% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invictor.R
\name{Counters}
\alias{Counters}
\alias{\%+-\%}
\alias{\%++\%}
\title{Counters}
\usage{
counter \%+-\% increment

counter \%++\% increment
}
\arguments{
\item{counter}{If \code{counter} and \code{increment} are both (signed/positive) integers \code{counter} will change by the value of \code{increment}.}

\item{increment}{An integer value \eqn{\neq 0} to add to \code{counter}}
}
\description{
Counters

Signed increment

Non-negative increment
}
\examples{
\dontrun{
# Signed increment
# Notice the difference between passing an object and a value for counter

# Value
(10 \%+-\% -5)
(10 \%+-\% -5)

# Object
i <- 10
(i \%+-\% -5)
(i \%+-\% -5)

# This means we can use the infix in a while ... statement
# WARNING: As is the case for any while ... statement, be careful not to create an infinite loop!

i <- 10
while(i > -5){
  i \%+-\% -5
  print(i)
}


# Non-negative increment
# Notice the difference between passing an object and a value for counter

# Value
(0 \%++\% 5)
(0 \%++\% 5)

# Object
i <- 0
(i \%++\% 5)
(i \%++\% 5)

# This means we can use the infix in a while ... statement
# WARNING: As is the case for any while ... statement, be careful not to create an infinite loop!

i <- 0
while(i < 20){
i \%++\% 5
print(i)
}
}

}
