% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData4cure.R
\name{simData4cure}
\alias{simData4cure}
\title{Simulate Data from Cox Cure Model with Uncertain Event Status}
\usage{
simData4cure(nSubject = 1e3,
             shape = 2, scale = 0.1,
             lambda_censor = 1, max_censor = Inf,
             p1 = 0.9, p2 = 0.9, p3 = 0.9,
             survMat, cureMat = survMat,
             b0 = stats::binomial()$linkfun(0.7),
             survCoef = rep(1, ncol(survMat)),
             cureCoef = rep(1, ncol(cureMat)),
             ...)
}
\arguments{
\item{nSubject}{A positive integer specifying number of subjects.}

\item{shape}{A positive number specifying the shape parameter of the
distribution of the event times.}

\item{scale}{A positive number specifying the scale parameter of the
distribution of the event times.}

\item{lambda_censor}{A positive number specifying the rate parameter of the
exponential distribution for generating censoring times.}

\item{max_censor}{A positive number specifying the largest censoring time.}

\item{p1}{A number between 0 and 1 specifying the probability of simulating
events with observed event indicators given the simulated event times.}

\item{p2}{A number between 0 and 1 specifying the probability of simulating
susceptible censoring times with observed event status given the
simulated susceptible censoring times.}

\item{p3}{A number between 0 and 1 specifying the probability of simulating
cured censoring times with observed event status given the simulated
cured censoring times.}

\item{survMat}{A numeric matrix representing the design matrix of the
survival model part.}

\item{cureMat}{A numeric matrix representing the design matrix excluding
intercept of the cure rate model part.}

\item{b0}{A number representing the intercept term for the cure rate model
part.}

\item{survCoef}{A numeric vector for the covariate coefficients of the
survival model part.}

\item{cureCoef}{A numeric vector for the covariate coefficients of the
cure model part.}

\item{...}{Other arguments not used currently.}
}
\value{
A data.frame with the following columns:
\itemize{

\item \code{obs_time}: Observed event/survival times.

\item \code{obs_event}: Observed event status.

\item \code{event_time}: Underlying true event times.

\item \code{censor_time}: underlying true censoring times.

\item \code{oracle_event}: underlying true event indicators.

\item \code{oracle_cure}: underlying true cure indicators.

\item \code{case}: underlying true case labels.

}
}
\description{
Simulate Data from Cox Cure Model with Uncertain Event Status
}
\examples{
## see examples of function cox_cure
}
\references{
Wang, W., Chen, K., Luo, C., & Yan, J. (2019+). Cox Cure Model with
Uncertain Event Status with application to a Suicide Risk
Study. \emph{Working in Progress}.
}
