% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_raw.R
\name{plot_raw}
\alias{plot_raw}
\title{Plot raw data}
\usage{
plot_raw(
  data,
  type = "boxplot",
  x,
  y,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xrotation = NULL,
  legend = "top",
  xtext = NULL,
  gtext = NULL,
  color = TRUE,
  opt = NULL
)
}
\arguments{
\item{data}{raw data}

\item{type}{Type of graphic. "boxplot"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{Limits and break of the y axis c(init, end, brakes)}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in groups}

\item{color}{Colored figure (TRUE), otherwise black & white (FALSE)}

\item{opt}{Add new layers to the plot}
}
\value{
plot
}
\description{
Function use the raw data for made a boxplot graphic
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/"
              , "edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

fb \%>\%
  plot_raw(type = "boxplot"
           , x = "geno"
           , y = "lfa"
           , group = "treat"
           , color = T
           )

}

}
