\name{triSht}
\title{A triangulation object}
\alias{triSht}
\description{
  R object that represents the triangulation of a set of 2D points,
  generated by \code{\link{tri.mesh}}.
}
\arguments{
  \item{n}{Number of nodes}
  \item{x}{\eqn{x} coordinates of the triangulation nodes}
  \item{y}{\eqn{y} coordinates of the triangulation nodes}
  \item{nt}{number of triangles}
  \item{trlist}{Matrix of indices which defines the triangulation,
    each row corresponds to a triangle.

    Columns \code{i1}, \code{i2}, \code{i3} of the row \eqn{i} contain
    the node indices defining the \eqn{i}th triangle.

    Columns \code{j1}, \code{j2}, \code{j3} of the row \eqn{i} contain
    the indices of neighbour triangles (or 0 if no neighbour available
    along the convex hull).

    Columns \code{k1}, \code{k2}, \code{k3} of the row \eqn{i} contain
    the indices of the arcs of the \eqn{i}th triangle as returned by the
    \code{\link{arcs}} function.
  }
  \item{cclist}{
    Matrix describing the circumcircles and triangles.

    Columns \code{x} and \code{y} contain coordinates of the
    circumcircle centers, \code{r} is the circumcircle radius.

    \code{area} is the triangle area and \code{ratio} is the ratio of
    the radius of the inscribed circle to the circumcircle radius. It
    takes it maximum value 0.5 for an equilateral triangle.

    The radius of the inscribed circle can be get via
    \eqn{r_i=\frac{r}{ratio}}.
  }
  \item{nchull}{number of points on the convex hull}
  \item{chull}{
    A vector containing the indices of nodes forming the convec hull (in
    counterclockwise ordering).
  }
  \item{narcs}{number of arcs forming the triangulation}
  \item{arcs}{A matrix with node indices describing the arcs, contains
    two columns \code{from} and \code{to}.
  }
  \item{call}{call, which generated this object}
}
\note{
  This object is not backward compatible with \code{tri} objects generated
  from package \code{tripack} but the functions and methods are! So you
  have to regenerate these objects and then you can continue to use the
  same calls as before.

  The only difference is that no constraints to the triangulation are
  possible in package \code{interp}.
}
\author{
  Albrecht Gebhardt <albrecht.gebhardt@aau.at>,
  Roger Bivand <roger.bivand@nhh.no>
}
\seealso{
  \code{\link{tri.mesh}}, \code{\link{print.triSht}},
  \code{\link{plot.triSht}}, \code{\link{summary.triSht}}
}
\keyword{spatial}
