% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spline.R
\name{plotINT}
\alias{plotINT}
\title{Plot the result of HR, OR or linear estimates}
\usage{
plotINT(
  x,
  xlab = "",
  main = "",
  log = FALSE,
  ylab = NULL,
  line1 = TRUE,
  color = "dodgerblue"
)
}
\arguments{
\item{x}{data.frame calculated using any of the function of this package}

\item{xlab}{xlab name}

\item{main}{plot title}

\item{log}{if TRUE, plot the estimate in log scale}

\item{ylab}{ylab name. Default is the estimate column name if log=FALSE otherwise Estimate(log scale)}

\item{line1}{if TRUE, plot horizontal line on 1 or 0 (if log=TRUE)}

\item{color}{line color. Default dodgerblue}
}
\value{
simple splined plot of estimates of var1 at var2 values
}
\description{
Create a spline var2 by 1 unit increase of var1
}
\examples{
library(rms)
library(survival)
data(cancer)
myformula <- Surv(time, status) ~ ph.karno + ph.ecog + rcs(age, 3)*sex
model <- cph(myformula , data = lung )
myHR <- rcsHR( var2values = 40:80
               , model = model , data = lung , var1 ="sex", var2="age"
               , ci=TRUE , conf = 0.95 , ci.method = "delta")
plotINT(myHR , ylab = "HR of male VS female" , xlab = "Age")
}
