% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosCnv}
\alias{CircosCnv}
\title{Create a CNV module to a moduleList}
\usage{
CircosCnv(
  modulename,
  compareGroup = 1,
  maxRadius = 200,
  minRadius = 190,
  width = 10,
  color = "#CAE1FF",
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  strokeColor = "black",
  strokeWidth = 1,
  opacity = 1,
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 50,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{compareGroup}{The group number of this module in compare module}

\item{maxRadius, minRadius}{Where the module should begin and end.}

\item{width}{Width for CNV module}

\item{color}{Color for CNV module}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{strokeColor, strokeWidth}{The color and width for stroke}

\item{opacity}{The opacity for module}

\item{animationDisplay}{Whether display animation}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of CNV with details including start, end, value, link, color and html.
Details can be found on document.}

\item{...}{Ignored}
}
\value{
The module tracks for cnv modules.
}
\description{
A copy number variance module displayed in the visualization
}
\examples{
cnvData<-cnvExample
Circos(CircosCnv('Cnv01',maxRadius =175, minRadius =116, data =cnvData,width=2,color = "#4876FF")+
CircosBackground("bg01",minRadius = 116,maxRadius = 175,fillColors = "#F2F2F2",axisShow = TRUE),
CNVMouseOverDisplay = TRUE)

}
