% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_4loss_ratio.R
\name{univariate_loss_ratio}
\alias{univariate_loss_ratio}
\title{Univariate loss ratio}
\usage{
univariate_loss_ratio(
  df,
  x,
  severity,
  premium,
  exposure = NULL,
  nclaims = NULL
)
}
\arguments{
\item{df}{data.frame with insurance portfolio}

\item{x}{column in \code{df} with risk factor}

\item{severity}{column in \code{df} with severity (default is NULL)}

\item{premium}{column in \code{df} with premium (default is NULL)}

\item{exposure}{column in \code{df} with exposure}

\item{nclaims}{column in \code{df} with number of claims}
}
\value{
An list of class \code{univ_lossratio} with components
\item{df}{data frame with average loss ratio}
\item{xvar}{name of column in df with risk factor}
\item{severity}{name of column in df with severity}
\item{nclaims}{name of column in df with number of claims}
\item{exposure}{name of column in df with exposure}
\item{premium}{name of column in df with premium}
}
\description{
Average loss ratio for discrete risk factors in an insurance portfolio. For each level of the risk factor the loss ratio is equal to the ratio between the severity and the earned premium.
}
\examples{
univariate_loss_ratio(MTPL2, x = area, severity = amount, premium = premium)
}
\author{
Martin Haringa
}
