% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_.R
\name{inspect_true_or_false}
\alias{inspect_true_or_false}
\title{Validate non-missing logical values}
\usage{
inspect_true_or_false(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_true_or_false} does not return any output. There are two possible scenarios:
\itemize{
\item The call is silent if \code{x} is a non-missing logical vector of \code{\link[base]{length}} 1.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_true_or_false} checks if an object is a non-missing logical vector of \code{\link[base]{length}} 1. This can be useful to validate inputs in user-defined functions.
}
\details{
\code{inspect_true_or_false} conducts a series of tests to check if \code{x} is a non-missing logical vector of \code{\link[base]{length}} 1. Namely, \code{inspect_true_or_false} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is an atomic vector of \code{\link[base]{length}} 1.
\item The \code{\link[base]{typeof}} \code{x} is logical.
\item \code{x} is \code{NA} or \code{NaN}.
}
}
\examples{
# Calls that pass silently:
x <- TRUE
y <- FALSE
inspect_true_or_false(x)
inspect_true_or_false(y)

# Calls that throw informative error messages:
mylist <- list(NULL, NA, NaN, 1, 0, "TRUE")
try(inspect_true_or_false(mylist[[1]]))
try(inspect_true_or_false(mylist[[2]]))
try(inspect_true_or_false(mylist[[3]]))
try(inspect_true_or_false(mylist[[4]]))
try(inspect_true_or_false(mylist[[5]]))
try(inspect_true_or_false(mylist[[6]]))

}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_character}} to validate character vectors.
\item \code{\link[inspector]{inspect_character_match}} to validate character vectors with predefined allowed values.
}
}
