% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{standardize_initialization}
\alias{standardize_initialization}
\title{Standardize initialization}
\usage{
standardize_initialization(
  x,
  arg = "data",
  by_col = TRUE,
  center = TRUE,
  scale = TRUE,
  col_ign = NULL,
  initialization = random_initialization(),
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress")
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{arg}{A character, the name(s) of the argument(s) to be standardized.
The argument must be of class \code{matrix} or \code{data.frame}.
Per default, \code{arg = "data"}.}

\item{by_col}{A boolean, set to \code{TRUE} (the default) to standardize column-wise, set
to \code{FALSE} to standardize by rows.}

\item{center}{A boolean, passed to \code{\link[base]{scale}}.}

\item{scale}{A boolean, passed to \code{\link[base]{scale}}.}

\item{col_ign}{A numeric vector of column indices (or row indices if \code{by_col = FALSE})
that are ignored when standardizing.}

\item{initialization}{An object of class \code{ino_call} which determines the initialization for
the standardized \code{ino} object. The \code{ino_call} is generated by any
of the strategy functions (any function with the name
\code{*_initialization}), when the \code{x} is unspecified.
Per default, \code{initialization = random_initialization()}, i.e. random
initialization.}

\item{ncores}{This function is parallelized, set the number of cores here.}

\item{verbose}{Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the standardize initialization
strategy.
}
\details{
For more details see the help vignette:
\code{vignette("workflow", package = "ino")}
}
\keyword{strategy}
