% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{random_initialization}
\alias{random_initialization}
\title{Random initialization}
\usage{
random_initialization(
  x,
  sampler = stats::rnorm,
  ...,
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress")
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{sampler}{The sampler for random initial values. Can be any function that
\itemize{
\item has as first argument an integer, say \code{npar},
\item and returns a numeric vector of length \code{npar}.
}
Per default, \code{sampler = stats::rnorm}, i.e. independent draws from a
standard normal distribution as initial value.}

\item{...}{Additional argument to \code{sampler} (optional).}

\item{ncores}{This function is parallelized, set the number of cores here.}

\item{verbose}{Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the random initialization strategy.
}
\details{
For more details see the help vignette:
\code{vignette("workflow", package = "ino")}
}
\keyword{strategy}
