% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innsight.R
\docType{package}
\name{innsight-package}
\alias{innsight}
\alias{innsight-package}
\title{Get the Insight of your Neural Network}
\description{
\code{innsight} is an R package that interprets the behavior and explains
individual predictions of modern neural networks. Many methods for
explaining individual predictions already exist, but hardly any of them
are implemented or available in R. Most of these so-called
\emph{'Feature Attribution'} methods are only implemented in Python and
thus difficult to access or use for the R community. In this sense,
the package \code{innsight} provides a common interface for various methods
for the interpretability of neural networks and can therefore be considered
as an R analogue to 'iNNvestigate' for Python.
}
\details{
This package implements several model-specific interpretability
(Feature Attribution) methods based on neural networks in R, e.g.,
\itemize{
\item Layer-wise Relevance Propagation (\link{LRP})
\itemize{
\item Including propagation rules: \eqn{\epsilon}-rule and
\eqn{\alpha}-\eqn{\beta}-rule
}
\item Deep Learning Important Features (\link{DeepLift})
\itemize{
\item Including propagation rules for non-linearities: rescale rule and
reveal-cancel rule
}
\item Gradient-based methods:
\itemize{
\item Vanilla \link{Gradient}, including 'Gradient x Input'
\item Smoothed gradients (\link{SmoothGrad}), including 'SmoothGrad x Input'
}
\item \link{ConnectionWeights}
}

The package \code{innsight} aims to be as flexible as possible and independent of a
specific deep learning package in which the passed network has been learned.
Basically, a Neural Network of the libraries \link[torch:nn_sequential]{torch::nn_sequential},
\link[keras:keras_model_sequential]{keras::keras_model_sequential}, \link[keras:keras_model]{keras::keras_model} and
\link[neuralnet:neuralnet]{neuralnet::neuralnet} can be passed to the main building block \link{Converter},
which converts and stores the passed model as a torch model
(\link{ConvertedModel}) with special insights needed for interpretation.
It is also possible to pass an arbitrary net in form of a named list
(see details in \link{Converter}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bips-hb.github.io/innsight/}
  \item \url{https://github.com/bips-hb/innsight/}
  \item Report bugs at \url{https://github.com/bips-hb/innsight/issues/}
}

}
\author{
\strong{Maintainer}: Niklas Koenen \email{niklas.koenen@gmail.com} (\href{https://orcid.org/0000-0002-4623-8271}{ORCID})

Other contributors:
\itemize{
  \item Raphael Baudeu \email{raphael.baudeu@gmail.com} [contributor]
}

}
