% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{make_inlamemi_scaling_vector}
\alias{make_inlamemi_scaling_vector}
\title{Construct scaling vector to scale the precision of correctly observed observations}
\usage{
make_inlamemi_scaling_vector(
  inlamemi_stack,
  error_type,
  classical_error_scaling = NULL,
  vars
)
}
\arguments{
\item{inlamemi_stack}{an object of class inlamemi.data.stack containing data structured}

\item{error_type}{type of error (one or more of "classical", "berkson", "missing")}

\item{classical_error_scaling}{can be specified if the classical measurement error varies across observations. Must be a vector of the same length as the data.}

\item{vars}{Results from a call to "extract_variables_from_formula" function. If this is not passed as an argument, it is called inside the function.}
}
\value{
A vector reflecting the scaling factor for the residual terms in each model level.
}
\description{
Construct scaling vector to scale the precision of correctly observed observations
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
stacks <- make_inlamemi_stacks(data = simple_data,
                             formula_moi = y ~ x + z,
                             formula_imp = x ~ z,
                             error_type = c("classical", "berkson"))
vars <- extract_variables_from_formula(formula_moi = y ~ x + z,
                                       formula_imp = x ~ z)
make_inlamemi_scaling_vector(stacks,
                           error_type = c("classical", "berkson"),
                           vars = vars)
\dontshow{\}) # examplesIf}
}
