% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_obs}
\alias{bru_obs}
\alias{like}
\alias{bru_like_list}
\alias{like_list}
\alias{bru_like_list.list}
\alias{bru_like_list.bru_like}
\alias{c.bru_like}
\alias{c.bru_like_list}
\alias{[.bru_like_list}
\title{Observation model construction for usage with \code{\link[=bru]{bru()}}}
\usage{
bru_obs(
  formula = . ~ .,
  family = "gaussian",
  data = NULL,
  response_data = NULL,
  E = NULL,
  Ntrials = NULL,
  weights = NULL,
  scale = NULL,
  domain = NULL,
  samplers = NULL,
  ips = NULL,
  include = NULL,
  exclude = NULL,
  include_latent = NULL,
  used = NULL,
  allow_combine = NULL,
  control.family = NULL,
  tag = NULL,
  options = list(),
  .envir = parent.frame()
)

like(
  formula = . ~ .,
  family = "gaussian",
  data = NULL,
  response_data = NULL,
  E = NULL,
  Ntrials = NULL,
  weights = NULL,
  scale = NULL,
  domain = NULL,
  samplers = NULL,
  ips = NULL,
  include = NULL,
  exclude = NULL,
  include_latent = NULL,
  used = NULL,
  allow_combine = NULL,
  control.family = NULL,
  tag = NULL,
  options = list(),
  .envir = parent.frame(),
  mesh = deprecated()
)

bru_like_list(...)

like_list(...)

\method{bru_like_list}{list}(object, envir = NULL, ...)

\method{bru_like_list}{bru_like}(..., envir = NULL)

\method{c}{bru_like}(..., envir = NULL)

\method{c}{bru_like_list}(..., envir = NULL)

\method{[}{bru_like_list}(x, i)
}
\arguments{
\item{formula}{a \code{formula} where the right hand side is a general R
expression defines the predictor used in the model.}

\item{family}{A string identifying a valid \code{INLA::inla} likelihood family.
The default is
\code{gaussian} with identity link. In addition to the likelihoods provided
by inla (see \code{names(INLA::inla.models()$likelihood)})
inlabru supports fitting latent Gaussian Cox
processes via \code{family = "cp"}.
As an alternative to \code{\link[=bru]{bru()}}, the \code{\link[=lgcp]{lgcp()}} function provides
a convenient interface to fitting Cox processes.}

\item{data}{Likelihood-specific data, as a \code{data.frame} or
\code{SpatialPoints[DataFrame]}
object.}

\item{response_data}{Likelihood-specific data for models that need different
size/format for inputs and response variables, as a \code{data.frame} or
\code{SpatialPoints[DataFrame]} object.}

\item{E}{Exposure parameter for family = 'poisson' passed on to \code{INLA::inla}.
Special case if family is 'cp': rescale all integration weights by a scalar
E. For sampler specific reweighting/effort, use a \code{weight} column in the
\code{samplers} object, see \code{\link[fmesher:fm_int]{fmesher::fm_int()}}. Default taken from \code{options$E},
normally \code{1}.}

\item{Ntrials}{A vector containing the number of trials for the 'binomial'
likelihood. Default taken from \code{options$Ntrials}, normally \code{1}.}

\item{weights}{Fixed (optional) weights parameters of the likelihood, so the
log-likelihood\verb{[i]} is changed into \code{weights[i] * log_likelihood[i]}.
Default value is \code{1}. WARNING: The normalizing constant for the likelihood
is NOT recomputed, so ALL marginals (and the marginal likelihood) must be
interpreted with great care.}

\item{scale}{Fixed (optional) scale parameters of the precision for several
models, such as Gaussian and student-t response models.}

\item{domain, samplers, ips}{Arguments used for \code{family="cp"}.
\describe{
\item{\code{domain}}{Named list of domain definitions.}
\item{\code{samplers}}{Integration subdomain for 'cp' family.}
\item{\code{ips}}{Integration points for 'cp' family. Defaults
to \code{fmesher::fm_int(domain, samplers)}. If explicitly given,
overrides \code{domain} and \code{samplers}.}
}}

\item{include, exclude, include_latent}{Arguments controlling what components
and effects are available for use in the predictor expression.
\describe{
\item{\code{include}}{
Character vector of component labels that are used as effects
by the predictor expression; If \code{NULL} (default), the \code{\link[=bru_used]{bru_used()}}
method is used to extract the variable names from the formula.
}
\item{\code{exclude}}{
Character vector of component labels to be excluded from the effect list
determined by the \code{include} argument. Default is \code{NULL}; do not remove
any components from the inclusion list.
}
\item{\code{include_latent}}{Character vector.
Specifies which latent state variables are directly available to the
predictor expression, with a \verb{_latent} suffix. This also makes evaluator
functions with suffix \verb{_eval} available, taking parameters \code{main}, \code{group},
and \code{replicate}, taking values for where to evaluate the component effect
that are different than those defined in the component definition itself
(see \code{\link[=bru_component_eval]{bru_component_eval()}}). If \code{NULL}, the \code{\link[=bru_used]{bru_used()}} method
auto-detects use of \verb{_latent} and \verb{_eval} in the predictor expression.
}
}}

\item{used}{Wither \code{NULL} (default) or a \code{\link[=bru_used]{bru_used()}} object, that overrides
the \code{include}, \code{exclude}, \code{include_latent} arguments.
When \code{used} is \code{NULL} (default), the information about what effects and
latent vectors are made available to the predictor evaluation is defined by

\if{html}{\out{<div class="sourceCode r">}}\preformatted{used <- bru_used(
  formula,
  effect = include,
  effect_exclude = exclude,
  latent = include_latent
)
}\if{html}{\out{</div>}}}

\item{allow_combine}{logical; If \code{TRUE}, the predictor expression may involve
several rows of the input data to influence the same row. When \code{NULL},
defaults to \code{FALSE}, unless \code{response_data} is non-\code{NULL}, or \code{data} is a
\code{list}, or the likelihood construction requires it.}

\item{control.family}{A optional \code{list} of \code{INLA::control.family} options}

\item{tag}{character; Name that can be used to identify the relevant parts
of INLA predictor vector output, via \code{\link[=bru_index]{bru_index()}}.}

\item{options}{A \link{bru_options} options object or a list of options passed
on to \code{\link[=bru_options]{bru_options()}}}

\item{.envir}{The evaluation environment to use for special arguments (\code{E},
\code{Ntrials}, \code{weights}, and \code{scale}) if not found in \code{response_data} or
\code{data}. Defaults to the calling environment.}

\item{mesh}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Ignored.}

\item{\dots}{For \code{bru_like_list.bru_like}, one or more \code{bru_like} objects}

\item{object}{A list of \code{bru_like} objects}

\item{envir}{An optional environment for the new \code{bru_like_list} object}

\item{x}{\code{bru_like_list} object from which to extract element(s)}

\item{i}{indices specifying elements to extract}
}
\value{
A likelihood configuration which can be used to parameterise \code{\link[=bru]{bru()}}.
}
\description{
Observation model construction for usage with \code{\link[=bru]{bru()}}.

Note: Prior to version \verb{2.12.0}, this function was called \code{like()}, and that
alias will remain for a while until examples etc have been updated and users
made aware of the change. The name change is to avoid issues with namespace
clashes, e.g. with \code{data.table::like()}, and also to signal that the function
defines observation models, not just likelihood functions.
}
\section{Functions}{
\itemize{
\item \code{like()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Legacy \code{like()}
method for \code{inlabru} prior to version \verb{2.12.0}. Use \code{\link[=bru_obs]{bru_obs()}} instead.

\item \code{bru_like_list()}: Combine \code{bru_like} likelihoods into a \code{bru_like_list} object

\item \code{like_list()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Legacy \code{like_list()}
alias. Use \code{\link[=bru_like_list]{bru_like_list()}} instead.

\item \code{bru_like_list(list)}: Combine a list of \code{bru_like} likelihoods
into a \code{bru_like_list} object

\item \code{bru_like_list(bru_like)}: Combine several \code{bru_like} likelihoods
into a \code{bru_like_list} object

\item \code{c(bru_like)}: Combine several \code{bru_like} likelihoods and/or \code{bru_like_list}
objects into a \code{bru_like_list} object

\item \code{c(bru_like_list)}: Combine several \code{bru_like} likelihoods and/or \code{bru_like_list}
objects into a \code{bru_like_list} object

}}
\examples{
\donttest{
if (bru_safe_inla() &&
    require(ggplot2, quietly = TRUE)) {

  # The like function's main purpose is to set up models with multiple
  # likelihoods.
  # The following example generates some random covariates which are observed
  # through two different random effect models with different likelihoods

  # Generate the data

  set.seed(123)

  n1 <- 200
  n2 <- 10

  x1 <- runif(n1)
  x2 <- runif(n2)
  z2 <- runif(n2)

  y1 <- rnorm(n1, mean = 2 * x1 + 3)
  y2 <- rpois(n2, lambda = exp(2 * x2 + z2 + 3))

  df1 <- data.frame(y = y1, x = x1)
  df2 <- data.frame(y = y2, x = x2, z = z2)

  # Single likelihood models and inference using bru are done via

  cmp1 <- y ~ -1 + Intercept(1) + x
  fit1 <- bru(cmp1, family = "gaussian", data = df1)
  summary(fit1)

  cmp2 <- y ~ -1 + Intercept(1) + x + z
  fit2 <- bru(cmp2, family = "poisson", data = df2)
  summary(fit2)

  # A joint model has two likelihoods, which are set up using the bru_obs
  # function

  lik1 <- bru_obs("gaussian", formula = y ~ x + Intercept, data = df1)
  lik2 <- bru_obs("poisson", formula = y ~ x + z + Intercept, data = df2)

  # The union of effects of both models gives the components needed to run bru

  jcmp <- ~ x + z + Intercept(1)
  jfit <- bru(jcmp, lik1, lik2)

  # Compare the estimates

  p1 <- ggplot() +
    gg(fit1$summary.fixed, bar = TRUE) +
    ylim(0, 4) +
    ggtitle("Model 1")
  p2 <- ggplot() +
    gg(fit2$summary.fixed, bar = TRUE) +
    ylim(0, 4) +
    ggtitle("Model 2")
  pj <- ggplot() +
    gg(jfit$summary.fixed, bar = TRUE) +
    ylim(0, 4) +
    ggtitle("Joint model")

  multiplot(p1, p2, pj)
}
}
}
\seealso{
\code{\link[=bru_response_size]{bru_response_size()}}, \code{\link[=bru_used]{bru_used()}}, \code{\link[=bru_component]{bru_component()}},
\code{\link[=bru_component_eval]{bru_component_eval()}}

\code{\link[=summary.bru_like]{summary.bru_like()}}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}

Finn Lindgren \email{finn.lindgren@gmail.com}
}
