% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlinla.R
\name{bru_compute_linearisation}
\alias{bru_compute_linearisation}
\alias{bru_compute_linearisation.component}
\alias{bru_compute_linearisation.bru_like}
\alias{bru_compute_linearisation.bru_like_list}
\alias{bru_compute_linearisation.bru_model}
\title{Compute inlabru model linearisation information}
\usage{
bru_compute_linearisation(...)

\method{bru_compute_linearisation}{component}(
  cmp,
  model,
  lhood_expr,
  data,
  input,
  state,
  comp_simple,
  effects,
  pred0,
  used,
  allow_latent,
  allow_combine,
  eps,
  ...
)

\method{bru_compute_linearisation}{bru_like}(
  lhood,
  model,
  data,
  input,
  state,
  comp_simple,
  eps,
  ...
)

\method{bru_compute_linearisation}{bru_like_list}(
  lhoods,
  model,
  input,
  state,
  comp_simple,
  eps = 0.00001,
  ...
)

\method{bru_compute_linearisation}{bru_model}(model, lhoods, input, state, comp_simple, ...)
}
\arguments{
\item{\dots}{Parameters passed on to other methods}

\item{cmp}{A \link{bru_component} object}

\item{model}{A \code{bru_model} object}

\item{lhood_expr}{A predictor expression}

\item{data}{Input data}

\item{input}{Precomputed component inputs from \code{evaluate_inputs()}}

\item{state}{The state information, as a list of named vectors}

\item{comp_simple}{Component evaluation information
\itemize{
\item For \code{bru_component}: \code{bru_mapper_taylor} object
\item For \code{bru_like}: A \code{comp_simple_list} object
for the components in the likelihood
\item For \code{bru_like_list}: A \code{comp_simple_list_list} object
}}

\item{effects}{\itemize{
\item For \code{bru_component}:
Precomputed effect list for all components involved in the likelihood
expression
}}

\item{pred0}{Precomputed predictor for the given state}

\item{used}{A \code{\link[=bru_used]{bru_used()}} object for the predictor expression}

\item{allow_latent}{logical. If \code{TRUE}, the latent state of each component is
directly available to the predictor expression, with a \verb{_latent} suffix.}

\item{allow_combine}{logical; If \code{TRUE}, the predictor expression may
involve several rows of the input data to influence the same row.}

\item{eps}{The finite difference step size}

\item{lhood}{A \code{bru_like} object}

\item{lhoods}{A \code{bru_like_list} object}
}
\description{
Compute inlabru model linearisation information
}
