% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_aggregated_profiles.R
\name{print.aggregated_profiles_explainer}
\alias{print.aggregated_profiles_explainer}
\title{Prints Aggregated Profiles}
\usage{
\method{print}{aggregated_profiles_explainer}(x, ...)
}
\arguments{
\item{x}{an individual variable profile explainer produced with the \code{aggregate_profiles()} function}

\item{...}{other arguments that will be passed to \code{head()}}
}
\description{
Prints Aggregated Profiles
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

selected_passangers <- select_sample(titanic_imputed, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_glm, selected_passangers)

head(cp_rf)

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              verbose = FALSE, precalculate = FALSE)

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)
}

}
