% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ceteris_paribus.R
\name{print.ceteris_paribus_explainer}
\alias{print.ceteris_paribus_explainer}
\title{Prints Individual Variable Explainer Summary}
\usage{
\method{print}{ceteris_paribus_explainer}(x, ...)
}
\arguments{
\item{x}{an individual variable profile explainer produced with the \code{ceteris_paribus()} function}

\item{...}{other arguments that will be passed to \code{head()}}
}
\description{
Prints Individual Variable Explainer Summary
}
\examples{
library("DALEX")
library("randomForest")

apartments_rf_model <- randomForest(m2.price ~., data = apartments)

explainer_rf <- explain(apartments_rf_model,
                        data = apartments_test[,-1],
                        y = apartments_test[,1])

apartments_small <- select_sample(apartments_test, 10)

cp_rf <- ceteris_paribus(explainer_rf, apartments_small)
cp_rf

}
