% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_residuals.R
\name{show_residuals}
\alias{show_residuals}
\title{Adds a Layer with Residuals to a Profile Plot}
\usage{
show_residuals(
  x,
  ...,
  size = 0.75,
  alpha = 1,
  color = c(`TRUE` = "#371ea3", `FALSE` = "#f05a71"),
  variables = NULL
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}.
Note that \code{y} parameter shall be supplied in this function.}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between \code{0} and \code{1}. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}
}
\value{
a \code{ggplot2} layer
}
\description{
Function \code{\link{show_residuals}} adds a layer to a plot created with
\code{\link{plot.ceteris_paribus_explainer}} for selected observations.
Note that the \code{y} argument has to be specified in the \code{\link{ceteris_paribus}} function.
}
\examples{
library("DALEX")
library("randomForest")

johny_d <- data.frame(
  class = factor("1st", levels = c("1st", "2nd", "3rd", "deck crew", "engineering crew",
                                   "restaurant staff", "victualling crew")),
  gender = factor("male", levels = c("female", "male")),
  age = 8,
  sibsp = 0,
  parch = 0,
  fare = 72,
  embarked = factor("Southampton", levels = c("Belfast", "Cherbourg", "Queenstown", "Southampton"))
)

\donttest{
model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed, ntree = 500)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "Random Forest v7")

johny_neighbours <- select_neighbours(data = titanic_imputed,
                                      observation = johny_d,
                                      variables = c("age", "gender", "class",
                                                  "fare", "sibsp", "parch"),
                                      n = 10)

cp_neighbours <- ceteris_paribus(explain_titanic_rf,
                                 johny_neighbours,
                                 y = johny_neighbours$survived == "yes",
                                 variable_splits = list(age = seq(0,70, length.out = 1000)))

plot(cp_neighbours, variables = "age") +
  show_observations(cp_neighbours, variables = "age")


cp_johny <- ceteris_paribus(explain_titanic_rf, johny_d,
                            variable_splits = list(age = seq(0,70, length.out = 1000)))

plot(cp_johny, variables = "age", size = 1.5, color = "#8bdcbe") +
  show_profiles(cp_neighbours, variables = "age", color = "#ceced9") +
  show_observations(cp_johny, variables = "age", size = 5, color = "#371ea3") +
  show_residuals(cp_neighbours, variables = "age")

}
}
