% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\alias{describe.ceteris_paribus_explainer}
\title{Describe Ceteris Paribus Explainers.}
\usage{
describe(x, ...)

\method{describe}{ceteris_paribus_explainer}(x, ...)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}
}
\value{
an `ceteris_paribus_descriptions` object.
}
\description{
Function \code{describe.ceteris_paribus_explainer} generates text descriptions for Ceteris Paribus Profiles.
Note that currently only first observation is being described.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")
cp_rf <- ceteris_paribus(explain_titanic_glm, titanic[1,])
cp_rf
describe(cp_rf)
plot(cp_rf)

 \donttest{
 library("randomForest")
 model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived == "yes",
                           label = "Random Forest v7")

selected_passangers <- select_sample(titanic, n = 1)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf
describe(cp_rf)

plot(cp_rf) +
  show_observations(cp_rf)
 }
}
