% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{confint.incubate_fit}
\alias{confint.incubate_fit}
\title{Confidence intervals for parameters of incubate-model fits.}
\usage{
\method{confint}{incubate_fit}(
  object,
  parm,
  level = 0.95,
  R = 199L,
  bs_data,
  bs_infer = c("logquantile", "lognormal", "quantile", "quantile0", "normal", "normal0"),
  useBoot = FALSE,
  ...
)
}
\arguments{
\item{object}{object of class \code{incubate_fit}}

\item{parm}{character. Which parameters to get confidence interval for?}

\item{level}{numeric. Which is the requested confidence level for the interval? Default value is 0.95}

\item{R}{number of bootstrap replications. Used only if not \code{bs_data}-object is provided.}

\item{bs_data}{character or bootstrap data object. If character, it specifies which type of bootstrap is requested and the bootstrap data will be generated. Data can also be provided here directly. If missing it uses parametric bootstrap.}

\item{bs_infer}{character. Which type of bootstrap inference is requested to generate the confidence interval?}

\item{useBoot}{logical. Delegate bootstrap confint calculation to the \code{boot}-package?}

\item{...}{further arguments, currently not used.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter.
}
\description{
Bias-corrected bootstrap confidence limits (either quantile-based or normal-approximation based) are generated.
Optionally, there are also variants that use a log-transformation first.
At least R=1000 bootstrap replications are recommended. Default are quantile-based confidence intervals that internally use a log-transformation.
}
