% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{mutate.incidence2}
\alias{mutate.incidence2}
\title{Create, modify, and delete incidence2 columns}
\usage{
\method{mutate}{incidence2}(
  .data,
  ...,
  .by,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.data}{An \link[=incidence]{incidence2} object.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}

\item{.by}{Not used as grouping structure implicit.}

\item{.keep}{Control which columns from \code{.data} are retained in the output. Grouping
columns and columns created by \code{...} are always kept.
\itemize{
\item \code{"all"} retains all columns from \code{.data}. This is the default.
\item \code{"used"} retains only the columns used in \code{...} to create new
columns. This is useful for checking your work, as it displays inputs
and outputs side-by-side.
\item \code{"unused"} retains only the columns \emph{not} used in \code{...} to create new
columns. This is useful if you generate new columns, but no longer need
the columns used to generate them.
\item \code{"none"} doesn't retain any extra columns from \code{.data}. Only the grouping
variables and columns created by \code{...} are kept.
}}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, control where new columns
should appear (the default is to add to the right hand side). See
\code{\link[dplyr:relocate]{relocate()}} for more details.}
}
\value{
A modified \link[=incidence]{incidence2} object if the necessary
invariants are preserved, otherwise a \link[tibble:tibble]{tibble}.
}
\description{
Method for \link[dplyr:mutate]{dplyr::mutate} that implicitly accounts for the inherent
grouping structure of incidence2 objects.
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE) && requireNamespace("ggplot2", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    ebola_sim_clean$linelist |>
        subset(!is.na(hospital)) |>
        incidence_(date_of_onset, hospital, interval = "isoweek") |>
        mutate(ave = data.table::frollmean(count, n = 3L, align = "right")) |>
        plot(border_colour = "white", angle = 45) +
        ggplot2::geom_line(ggplot2::aes(x = date_index, y = ave))
}
\dontshow{data.table::setDTthreads(.old)}

}
\seealso{
\link[dplyr:mutate]{dplyr::mutate} for the underlying generic.
}
