% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as.data.frame.incidence}
\alias{as.data.frame.incidence}
\alias{as.incidence}
\alias{as.incidence.matrix}
\alias{as.incidence.data.frame}
\alias{as.incidence.numeric}
\title{Conversion of incidence objects}
\usage{
\method{as.data.frame}{incidence}(x, ..., long = FALSE)

as.incidence(x, ...)

\method{as.incidence}{matrix}(x, dates = NULL, interval = NULL,
  isoweeks = TRUE, ...)

\method{as.incidence}{data.frame}(x, dates = NULL, interval = NULL,
  isoweeks = TRUE, ...)

\method{as.incidence}{numeric}(x, dates = NULL, interval = NULL,
  isoweeks = TRUE, ...)
}
\arguments{
\item{x}{An \code{incidence} object, or an object to be converted as
\code{incidence} (see details).}

\item{...}{Further arguments passed to other functions (no used).}

\item{long}{A logical indicating if the output data.frame should be 'long', i.e. where a single
column containing 'groups' is added in case of data computed on several groups.}

\item{dates}{A vector of dates, each corresponding to the (inclusive) lower
limit of the bins.}

\item{interval}{An integer indicating the time interval used in the
computation of the incidence. If NULL, it will be determined from the first
time interval between provided dates. If only one date is provided, it will
trigger an error.}

\item{isoweeks}{A logical indicating whether isoweeks should be used in the
case of weekly incidence; defaults to \code{TRUE}.}
}
\description{
These functions convert \code{incidence} objects into other classes.
}
\details{
Conversion to \code{incidence} objects should only be done when the
original dates are not available. In such case, the argument \code{x}
should be a matrix corresponding to the \code{$counts} element of an
\code{incidence} object, i.e. giving counts with time intervals in rows and
named groups in columns. In the absence of groups, a single unnamed columns
should be given. \code{data.frame} and vectors will be coerced to a matrix.
}
\examples{
## create fake data
data <- c(0,1,1,2,1,3,4,5,5,5,5,4,4,26,6,7,9)
sex <- sample(c("m","f"), length(data), replace=TRUE)

## get incidence per group (sex)
i <- incidence(data, groups = sex)
i
plot(i)

## convert to data.frame
as.data.frame(i)

## same, 'long format'
as.data.frame(i, long = TRUE)



## conversion from a matrix of counts to an incidence object
i$counts
new_i <- as.incidence(i$counts, i$dates)
new_i
all.equal(i, new_i)

}
\seealso{
the \code{\link[=incidence]{incidence()}} function to generate the 'incidence' objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}, Rich Fitzjohn
}
