% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incgraph_wrapper.R
\name{calculate.orbit.counts}
\alias{calculate.orbit.counts}
\title{Calculate orbit counts from scratch}
\usage{
calculate.orbit.counts(network)
}
\arguments{
\item{network}{An instance of the incgraph.network class}
}
\value{
An N-by-73 matrix, with N the number of nodes in the network and 1 column for each possible orbit.
The value of \code{mat[i,j]} is the number of times node \code{i} has orbit \code{j} in a subgraph in the network.
}
\description{
\code{calculate.orbit.counts} calculates the orbit counts of the current network.
}
\details{
The complete orbit counts is calcucated using the \code{\link{count5}} from the \code{orca} package.

Calling this method repeatedly becomes very inefficient for evolving networks. For evolving networks, the usage
of \code{\link{calculate.delta}} is recommended.

For more details on this method, see Hočevar and Demšar (2014).
}
\references{
Hočevar, T. and Demšar J. (2014) A combinatorial approach to graphlet counting. Bioinformatics.
}
\seealso{
See \code{\link{new.incgraph.network}} for examples and usage.
}
