% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.barMissing.R
\name{vis.barMissing}
\alias{vis.barMissing}
\title{Visualize Distribution of Missing Values as a Barplot}
\usage{
vis.barMissing(ts.withNA, na.identifier = NA, breaks = 10,
  breaksize = NULL, percentage = T, legend = T, ...)
}
\arguments{
\item{ts.withNA}{Time Series (\code{\link{ts}}) object with NAs}

\item{na.identifier}{Missing Value Identifier. 
If another value than NA indicates missing values this can be specified here. 
Identifier can be a character string as well as a numeric value.}

\item{breaks}{Defines the number of bins to be created. If breaksize isn't NULL it is overpowered
by this parameter}

\item{breaksize}{Defines how many observations should be in one bin. The required number of 
overall bins is afterwards calculated automatically.}

\item{percentage}{Whether the NA / non-NA ration should be given as percent or absolute numbers}

\item{legend}{If true a legend is shown above the plot.}

\item{...}{Additional graphical parameters like e.g. main that can be passed through to barplot}
}
\description{
Visualization of missing values in barplot form. Especially useful for
time series with a lot of observations.
}
\examples{
#Load dataset
data(heating)

#Visualize the missing values in this time series
vis.barMissing(heating, breaks = 20)

}
\author{
Steffen Moritz
}

