% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_impute_AR1_t.R
\name{fit_AR1_t}
\alias{fit_AR1_t}
\title{Fit Student's t AR(1) model to time series with missing values}
\usage{
fit_AR1_t(
  y,
  random_walk = FALSE,
  zero_mean = FALSE,
  fast_and_heuristic = TRUE,
  return_iterates = FALSE,
  return_condMean_Gaussian = FALSE,
  tol = 1e-10,
  maxiter = 100,
  n_chain = 10,
  n_thin = 1,
  K = 30
)
}
\arguments{
\item{y}{Time series object coercible to either a numeric vector or numeric matrix 
(e.g., \code{zoo} or \code{xts}) with missing values denoted by \code{NA}.}

\item{random_walk}{Logical value indicating if the time series is assumed to be a random walk so that \code{phi1 = 1} 
(default is \code{FALSE}).}

\item{zero_mean}{Logical value indicating if the time series is assumed zero-mean so that \code{phi0 = 0} 
(default is \code{FALSE}).}

\item{fast_and_heuristic}{Logical value indicating whether a heuristic but fast method is to be used to 
estimate the parameters of the Student's t AR(1) model (default is \code{TRUE}).}

\item{return_iterates}{Logical value indicating if the iterates are to be returned (default is \code{FALSE}).}

\item{return_condMean_Gaussian}{Logical value indicating if the conditional mean and covariance matrix of the 
time series (excluding the leading and trailing missing values) given the observed 
data are to be returned (default is \code{FALSE}).}

\item{tol}{Positive number denoting the relative tolerance used as stopping criterion (default is \code{1e-8}).}

\item{maxiter}{Positive integer indicating the maximum number of iterations allowed (default is \code{100}).}

\item{n_chain}{Positive integer indicating the number of the parallel Markov chains in the stochastic 
EM method (default is \code{10}).}

\item{n_thin}{Positive integer indicating the sampling period of the Gibbs sampling in the stochastic 
EM method (default is \code{1}). Every \code{n_thin}-th samples is used. This is aimed 
to reduce the dependence of the samples.}

\item{K}{Positive number controlling the values of the step sizes in the stochastic EM method 
(default is \code{30}).}
}
\value{
If the argument \code{y} is a univariate time series (i.e., coercible to a numeric vector), then this 
        function will return a list with the following elements:
\item{\code{phi0}}{The estimate for \code{phi0} (real number).}
\item{\code{phi1}}{The estimate for \code{phi1} (real number).}
\item{\code{sigma2}}{The estimate for \code{sigma^2} (positive number).}
\item{\code{nu}}{The estimate for \code{nu} (positive number).}
\item{\code{phi0_iterates}}{Numeric vector with the estimates for \code{phi0} at each iteration
                           (returned only when \code{return_iterates = TRUE}).}
\item{\code{phi1_iterates}}{Numeric vector with the estimates for \code{phi1} at each iteration
                           (returned only when \code{return_iterates = TRUE}).}
\item{\code{sigma2_iterates}}{Numeric vector with the estimates for \code{sigma^2} at each iteration
                             (returned only when \code{return_iterates = TRUE}).}
\item{\code{nu_iterate}}{Numeric vector with the estimates for \code{nu} at each iteration
                         (returned only when \code{return_iterates = TRUE}).}
\item{\code{f_iterates}}{Numeric vector with the objective values at each iteration
                         (returned only when \code{return_iterates = TRUE}).}
\item{\code{cond_mean_y_Gaussian}}{Numeric vector (of same length as argument \code{y}) with the conditional mean of the 
                                   time series (excluding the missing values at the head and tail) given the observed data based on Gaussian AR(1) model
                                   (returned only when \code{return_condMean_Gaussian = TRUE}).}

If the argument \code{y} is a multivariate time series (i.e., with multiple columns and coercible to a numeric matrix), 
then this function will return a list with each element as in the case of univariate \code{y} corresponding to each
of the columns (i.e., one list element per column of \code{y}), with the following additional elements that combine the 
estimated values in a convenient vector form:
\item{\code{phi0_vct}}{Numeric vector (with length equal to the number of columns of \code{y})
                       with the estimates for \code{phi0} for each of the univariate time series.}
\item{\code{phi1_vct}}{Numeric vector (with length equal to the number of columns of \code{y})
                       with the estimates for \code{phi1} for each of the univariate time series.}
\item{\code{sigma2_vct}}{Numeric vector (with length equal to the number of columns of \code{y})
                       with the estimates for \code{sigma2} for each of the univariate time series.}
\item{\code{nu_vct}}{Numeric vector (with length equal to the number of columns of \code{y})
                     with the estimates for \code{nu} for each of the univariate time series.}
}
\description{
Estimate the parameters of a univariate Student's t AR(1) 
             model to fit the given time series with missing values. 
             For multivariate time series, the function will perform a 
             number of indidivual univariate fittings without attempting 
             to model the correlations among the time series.
             If the time series does not contain missing values, the 
             maximum likelihood (ML) estimation is done via the iterative
             EM algorithm until converge is achieved.
             With missing values, the stochastic EM algorithm is employed 
             for the estimation (currently the maximum number of iterations
             will be executed without attempting to check early converge).
}
\examples{
library(imputeFin)
data(ts_AR1_t) 
y_missing <- ts_AR1_t$y_missing
fitted <- fit_AR1_t(y_missing)

}
\references{
J. Liu, S. Kumar, and D. P. Palomar, "Parameter estimation of heavy-tailed AR model with missing 
data via stochastic EM," IEEE Trans. on Signal Processing, vol. 67, no. 8, pp. 2159-2172, 15 April, 2019.
}
\author{
Junyan Liu and Daniel P. Palomar
}
