% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_wear.R
\name{plot_nonwear}
\alias{plot_nonwear}
\title{Plot the non-wear time detection}
\usage{
plot_nonwear(data, window2, nonwear_stage1, nonwear_stage2, save_plot)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{window2}{Window 2 size, in minutes, for the non-wear
detection algorithm. Must be the same value as used by the
\code{detect_nonwear()} function.}

\item{nonwear_stage1, nonwear_stage2}{A numeric vector containing the
binary non-wear classification (0 is wear and 1 is non-wear) of each
algorithm's stage per \code{window2} blocks as obtained with the
\link[=detect_nonwear]{detect_nonwear()} function.}

\item{save_plot}{Indicates whether of not to save the plot to visualize the
detected non-wear periods to a pdf file. Provide a valid path to a file
ending with the ".pdf" extension as a character string if you want the
plot to be saved.}
}
\value{
If \code{save_plot = FALSE} it returns the plot, otherwise it
saves it.
}
\description{
Draws a plot of the resultant acceleration in epochs of \code{window2} size
marking the non-wear time detected by each stage of the non-wear detection
algorithm.
}
\details{
This is an internal function, designed to be used inside the wrapper
function \link[=remove_nonwear]{remove_nonwear()} that integrates all
steps of detection, removal and inspection of accelerometer non-wear time.
}
\seealso{
\code{\link[=detect_nonwear]{detect_nonwear()}},
\code{\link[=mark_nonwear]{mark_nonwear()}},
\code{\link[=summarise_nonwear]{summarise_nonwear()}},
\code{\link[=delete_nonwear]{delete_nonwear()}}
}
\keyword{internal}
