% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imf_get.R
\name{imf_get}
\alias{imf_get}
\title{Retrieve data from an IMF dataset}
\usage{
imf_get(
  dataflow_id,
  dimensions = list(),
  start_period = NULL,
  end_period = NULL,
  progress = FALSE,
  max_tries = 10L,
  cache = TRUE
)
}
\arguments{
\item{dataflow_id}{Character scalar. The dataflow to query (e.g., "GFS").}

\item{dimensions}{Named list mapping dimension IDs to character vectors of
codes to include. Omitted dimensions are wildcarded in the key. Each
dimension position in the DSD corresponds to one dot-separated slot in the
key; multiple codes per slot are joined by '+'.}

\item{start_period}{Optional character. Lower bound for time filtering
(e.g., "2000", "2000-Q1", "2000-01").}

\item{end_period}{Optional character. Upper bound for time filtering, same
format as \code{start_period}.
The request always uses the SDMX 3.0 \code{dataflow} context under the hood and
sets \code{dimensionAtObservation = "TIME_PERIOD"} to request a time-series view.}

\item{progress}{Logical; whether to show request progress.}

\item{max_tries}{Integer; maximum retry attempts for HTTP requests.}

\item{cache}{Logical; whether to enable caching for HTTP requests.}
}
\value{
A tibble with one row per observation, including dimension columns,
time period, value column(s), and any requested attributes. Exact column
names follow the dataset's DSD and may vary by \code{dataflow_id}.
}
\description{
Fetches observations for a given \code{dataflow_id} and \code{resource_id} from the
IMF SDMX 3.0 Data API. The request key is constructed from the dataset's
datastructure (DSD) using the positional order of dimensions. Time filtering
is applied via query parameters.
}
\details{
By default, the request targets the \code{all} agencies scope for the data path,
assuming dataflow IDs are globally unique in practice. The response layout
uses a time-series context, and client code will shape the parsed payload
into a tidy tibble.

The request key is built by ordering dimensions by their DSD \code{position} and
filling each position with either a '+'-joined set of selected codes or a
blank for wildcard. Time filtering is applied via \code{start_period} and
\code{end_period} query parameters rather than encoding time into the key.
}
\examples{
if (curl::has_internet()) {
  imf_get(
    dataflow_id = "FM",  # Fiscal Monitor
    dimensions = list(COUNTRY = c("USA", "CAN"))
  )
}
}
