% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racog.R
\name{trainWrapper}
\alias{trainWrapper}
\title{Generic methods to train classifiers}
\usage{
trainWrapper(wrapper, train, trainClass, ...)
}
\arguments{
\item{wrapper}{the wrapper instance}

\item{train}{\code{data.frame} of the train dataset without the class column}

\item{trainClass}{a vector containing the class column for \code{train}}

\item{...}{further arguments for \code{wrapper}}
}
\value{
A model which is \code{\link[stats]{predict}} callable.
}
\description{
Generic methods to train classifiers
}
\examples{
myWrapper <- structure(list(), class="C50Wrapper")
trainWrapper.C50Wrapper <- function(wrapper, train, trainClass){
  C50::C5.0(train, trainClass)
}
}
\seealso{
\code{\link[stats]{predict}}
}
