% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{inpaint}
\alias{inpaint}
\title{Fill-in NA values in an image}
\usage{
inpaint(im, sigma)
}
\arguments{
\item{im}{input image}

\item{sigma}{std. deviation of the Gaussian (size of neighbourhood)}
}
\value{
an image with missing values filled-in.
}
\description{
Fill in NA values (inpainting) using a Gaussian filter, i.e. replace missing pixel values with a weighted average of the neighbours.
}
\examples{
im <- boats
im[sample(nPix(im),1e4)] <- NA
inpaint(im,1) \%>\% imlist(im,.) \%>\%
   setNames(c("before","after")) \%>\% plot(layout="row")
}
\author{
Simon Barthelme
}
