% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imTools.R
\name{update.impinf}
\alias{update.impinf}
\alias{update2.impinf}
\title{Applying Bayes Rule}
\usage{
\method{update}{impinf}(object, y = NULL, wrt = c("canonical", "mean"), ...)

update2.impinf(object, y = NULL, ...)
}
\arguments{
\item{object}{an object for which an update is needed}

\item{y}{vector of observations}

\item{wrt}{parameterization method with respect to canonical or mean}

\item{...}{further arguments passed to methods}
}
\description{
The Bayes rule is applied to an imprecise prior and produce an imprecise posterior.
}
\examples{

# 2-dimensions
lc0 <- list(lhs=rbind(diag(2), -diag(2)), rhs=c(0,0,-1,-1))
op <- iprior(ui=rbind(diag(2), -diag(2)), ci=c(0,0,-1,-1)) 
op <- iprior(ui=rbind(c(1,0),c(0,1),c(-1,-1)), ci=c(0,0,-5)) 
op <- iprior(ui=rbind(c(1,0),c(0,1),c(0,-1),c(1,1),c(-2,-1)), 
             ci=c(1,2,-8,5,-14)) # (3,8),(1,8), (1,4),(3,2)(6,2)
op1 <- update(op, y=NULL)

# 3-dimensions
lc0 <- rbind(c(1,2,0), c(1,-2,0), c(0.5,-2,0), c(0.5,2,0)) 
op <- iprior(pmat=lc0)
op1 <- update(op, y=NULL)

}

