% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{make_clusters}
\alias{make_clusters}
\title{Creates a communities object.}
\usage{
make_clusters(
  graph,
  membership = NULL,
  algorithm = NULL,
  merges = NULL,
  modularity = TRUE
)
}
\arguments{
\item{graph}{The graph of the community structure.}

\item{membership}{The membership vector of the community structure, a
numeric vector denoting the id of the community for each vertex. It
might be \code{NULL} for hierarchical community structures.}

\item{algorithm}{Character string, the algorithm that generated
the community structure, it can be arbitrary.}

\item{merges}{A merge matrix, for hierarchical community structures (or
\code{NULL} otherwise.}

\item{modularity}{Modularity value of the community structure. If this
is \code{TRUE} and the membership vector is available, then it the
modularity values is calculated automatically.}
}
\value{
A \code{communities} object.
}
\description{
This is useful to integrate the results of community finding algorithms
that are not included in igraph.
}
\seealso{
Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\concept{community}
