% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{degree}
\alias{degree}
\alias{degree_distribution}
\title{Degree and degree distribution of the vertices}
\usage{
degree(
  graph,
  v = V(graph),
  mode = c("all", "out", "in", "total"),
  loops = TRUE,
  normalized = FALSE
)

degree_distribution(graph, cumulative = FALSE, ...)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{v}{The ids of vertices of which the degree will be calculated.}

\item{mode}{Character string, \dQuote{out} for out-degree, \dQuote{in} for
in-degree or \dQuote{total} for the sum of the two. For undirected graphs
this argument is ignored. \dQuote{all} is a synonym of \dQuote{total}.}

\item{loops}{Logical; whether the loop edges are also counted.}

\item{normalized}{Logical scalar, whether to normalize the degree.  If
\code{TRUE} then the result is divided by \eqn{n-1}, where \eqn{n} is the
number of vertices in the graph.}

\item{cumulative}{Logical; whether the cumulative degree distribution is to
be calculated.}

\item{\dots}{Additional arguments to pass to \code{degree()}, e.g. \code{mode}
is useful but also \code{v} and \code{loops} make sense.}
}
\value{
For \code{degree()} a numeric vector of the same length as argument
\code{v}.

For \code{degree_distribution()} a numeric vector of the same length as the
maximum degree plus one. The first element is the relative frequency zero
degree vertices, the second vertices with degree one, etc.
}
\description{
The degree of a vertex is its most basic structural property, the number of
its adjacent edges.
}
\examples{

g <- make_ring(10)
degree(g)
g2 <- sample_gnp(1000, 10 / 1000)
degree_distribution(g2)

}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
