% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{print.igraph.es}
\alias{print.igraph.es}
\title{Print an edge sequence to the screen}
\usage{
\method{print}{igraph.es}(x, full = igraph_opt("print.full"), ...)
}
\arguments{
\item{x}{An edge sequence.}

\item{full}{Whether to show the full sequence, or truncate the output
to the screen size.}

\item{...}{Currently ignored.}
}
\value{
The edge sequence, invisibly.
}
\description{
For long edge sequences, the printing is truncated to fit to the
screen. Use \code{print} explicitly and the code{full} argument to
see the full sequence.
}
\details{
Edge sequences created with the double bracket operator are printed
differently, together with all attributes of the edges in the sequence,
as a table.
}
\examples{
# Unnamed graphs
g <- make_ring(10)
E(g)

# Named graphs
g2 <- make_ring(10) \%>\%
  set_vertex_attr("name", value = LETTERS[1:10])
E(g2)

# All edges in a long sequence
g3 <- make_ring(200)
E(g3)
E(g3) \%>\% print(full = TRUE)

# Metadata
g4 <- make_ring(10) \%>\%
  set_vertex_attr("name", value = LETTERS[1:10]) \%>\%
  set_edge_attr("weight", value = 1:10) \%>\%
  set_edge_attr("color", value = "green")
E(g4)
E(g4)[[]]
E(g4)[[1:5]]
}
\seealso{
Other vertex and edge sequences: \code{\link{E}},
  \code{\link{V}}, \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{print.igraph.vs}}
}
