% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_star}
\alias{make_star}
\alias{graph.star}
\alias{star}
\title{Create a star graph, a tree with n vertices and n - 1 leaves}
\usage{
make_star(n, mode = c("in", "out", "mutual", "undirected"), center = 1)

star(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{mode}{It defines the direction of the
edges, \code{in}: the edges point \emph{to} the center, \code{out}:
the edges point \emph{from} the center, \code{mutual}: a directed
star is created with mutual edges, \code{undirected}: the edges
are undirected.}

\item{center}{ID of the center vertex.}

\item{...}{Passed to \code{make_star}.}
}
\value{
An igraph graph.
}
\description{
\code{star} creates a star graph, in this every single vertex is
connected to the center vertex and nobody else.
}
\examples{
make_star(10, mode = "out")
make_star(5, mode = "undirected")
}
\seealso{
Other determimistic constructors: \code{\link{graph_from_atlas}},
  \code{\link{graph_from_edgelist}},
  \code{\link{graph_from_literal}},
  \code{\link{make_chordal_ring}},
  \code{\link{make_empty_graph}},
  \code{\link{make_full_citation_graph}},
  \code{\link{make_full_graph}}, \code{\link{make_graph}},
  \code{\link{make_lattice}}, \code{\link{make_ring}},
  \code{\link{make_tree}}
}
\concept{
Star graph
}
