% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality_rate.R
\encoding{UTF-8}
\name{mortality_rate}
\alias{mortality_rate}
\title{Mortality Rate}
\usage{
mortality_rate(number_people_dead, population_size, n)
}
\arguments{
\item{number_people_dead}{numeric vector that contains the number of people
dead for a time period}

\item{population_size}{numeric vector that contains the total population
size of which the deaths occurred}

\item{n}{numeric vector that contains the population size units (ex., 3 for
1,000 people, 5 for 100,000 people)}
}
\value{
the mortality rate as a numeric vector
}
\description{
This function calculates the mortality rate which is also known as the crude
death rate for a given population.
}
\examples{

# Example from Reference 1

library(iemisc)

mortality_rate(369369, 331534662, 5)







}
\references{
\enumerate{
   \item Giovanni Scerra, Published Sep 26, 2021, "The Math of the Pandemic: COVID-19 Mortality Rate", LinkedIn, \url{https://www.linkedin.com/pulse/math-pandemic-covid-19-mortality-rate-giovanni-scerra-}.
   \item Michael Darcy and Łucja Zaborowska, MD, PhD, Last updated on Nov 05, 2022, "Mortality Rate Calculator", Omni Calculator, \url{https://www.omnicalculator.com/health/mortality-rate}.
 }
}
\author{
Irucka Embry
}
