% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR.R
\name{SIR_vaccination_demographics_ode}
\alias{SIR_vaccination_demographics_ode}
\title{Susceptible-Infected-Recovered Model with Simple Demographics and Vaccination}
\usage{
SIR_vaccination_demographics_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
Susceptible-Infected-Recovered Model with Simple Demographics and Vaccination
}
\examples{
##Model Input
S_u_0 <- 989
I_u_0 <- 1
R_u_0 <- 0
S_v_0 <- 0
I_v_0 <- 0
R_v_0 <- 0
beta <- 3
tau <- 2
mu <- 1/81
alpha <- 0.8
lambda <- 0.7

parameters <- c(beta = beta, tau = tau, mu = mu,
                alpha = 0.8, lambda = 0.7)
inits <- c(S_u = S_u_0, I_u = I_u_0, R_u_0 = R_u_0,
           S_v = S_v_0, I_v = I_v_0, R_v_0 = R_v_0)

SIR_vaccination_demographics_ode(1, inits, parameters)
}
