% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markpos.R
\docType{data}
\name{markpos}
\alias{markpos}
\alias{bigdfOfMarks}
\alias{dfOfMarks}
\alias{dfOfMarks2}
\alias{humMarkPos}
\alias{allMarksSample}
\title{Mark Positional data - monocentrics}
\format{bigdfOfMarks a data.frame with cols:
\describe{
\item{OTU}{OTU, species, mandatory if in dfChrSize}
\item{chrName}{name of chromosome}
\item{markName}{name of mark}
\item{markArm}{use p for short arm, q for long arm, and cen for centromeric}
\item{markDistCen}{distance of mark to centromere (not for cen)}
\item{markSize}{size of mark (not for cen)}
}}
\source{
\href{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}{Washington U}
}
\usage{
bigdfOfMarks

dfOfMarks

dfOfMarks2

humMarkPos

allMarksSample
}
\description{
When several OTUs, some can be monocen. and others holocen. Marks distance for monocen. are measured from cen. and for
holocen. from top or bottom depending on \code{param} \code{origin}. See vignettes.

bigdfOfMarks: Example data for mark position with column OTU

dfOfMarks: Example data for marks' position

dfOfMarks2: Marks' position including cen. marks

humMarkPos: human karyotype marks' position

allMarksSample: Example data for marks' position
}
\references{
Adler 1994. Idiogram Album. URL: \href{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}{Washington U.}
}
\seealso{
\code{\link{markdataholo}}

\code{\link{plotIdiograms}}

\code{\link{chrbasicdatamono}}

\code{\link{dfMarkColor}}
}
\keyword{datasets}
