% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ngq_aa}
\alias{ngq_aa}
\title{Ego Networks Elicited from the "Important Matters" Name Generator Question (Alter-Alter Edgelist)}
\format{
A data frame with 123 rows and 5 columns:
\describe{
  \item{ego_id}{Unique identifier for ego providing network}
  \item{alter1}{Within-network unique identifier for Alter 1 in alter-alter edgelist.}
  \item{alter2}{Within-network unique identifier for Alter 2 in alter-alter edgelist.}
  \item{type}{A character indicating the type of relationship that Alter 1 and Alter 2 have with one another. Note that each dyad-type combination has its own unique row in this dataset, so more than one row may correspond to a single dyad if the dyad involves multiple types of relationships.}
  \item{freqtalk}{A numeric indicating how frequently ego believes Alter 1 and Alter 2 talk with one another. \code{1} indicates "Never," \code{2} "Less than once a month," \code{3} "1-3 times a month," \code{4} "1-3 times a week," \code{5} "Daily or almost daily."}
  ...
}
}
\source{
Original Data, Collected by Danielle Montagne, Joseph Quinn, Liann Tucker, and Tom Wolff.
}
\usage{
ngq_aa
}
\description{
This dataset contains a simplified subset of 20 ego networks elicited using the "important matters" name generator question (NGQ),
which is frequently used to capture an individual's close personal ties. These networks were collected as part
of an experiment illustrating how networks generated by this question may vary depending on the topics covered in
preceding survey items. Networks were collected using an online survey deployed via Amazon Mechanical Turk.
}
\keyword{datasets}
