% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{id_plot_legis}
\alias{id_plot_legis}
\title{Plot Legislator/Person and Bill/Item Ideal Points}
\usage{
id_plot_legis(object, return_data = FALSE, item_plot = NULL,
  text_size_label = 2, text_size_group = 2.5, point_size = 1,
  hjust_length = -0.7, person_labels = TRUE, group_labels = F,
  person_ci_alpha = 0.1, show_score = NULL, abs_and_reg = "both",
  show_true = FALSE, group_color = TRUE, hpd_limit = 10,
  group_overlap = FALSE, sample_persons = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{return_data}{If true, the calculated legislator/bill data is returned along with the plot in a list}

\item{item_plot}{The column index of the bill/item midpoint to overlay on the plot}

\item{text_size_label}{ggplot2 text size for legislator labels}

\item{text_size_group}{ggplot2 text size for group text used for points}

\item{point_size}{If \code{person_labels} and \code{group_labels} are set to \code{FALSE}, controls the size of the points plotted.}

\item{hjust_length}{horizontal adjustment of the legislator labels}

\item{person_labels}{if \code{TRUE}, use the person.names column to plot labels for the person (legislator) ideal points}

\item{group_labels}{if \code{TRUE}, use the group column to plot text markers for the group (parties) from the person/legislator data}

\item{person_ci_alpha}{The transparency level of the dot plot and confidence bars for the person ideal points}

\item{show_score}{Show only person/legislator ideal points that have a certain score/vote category from the outcome (character string)}

\item{abs_and_reg}{Whether to show 'both' absence and regular item/bill midpoints if the model is absence-inflated, the default,
or 'Absence Points' for only the absence midpoints or 'Vote Points' for only the non-inflated midpoints}

\item{show_true}{Whether to show the true values of the legislators (if model has been simulated)}

\item{group_color}{If \code{TRUE}, give each group/bloc a different color}

\item{hpd_limit}{The greatest absolute difference in high-posterior density interval shown for any point. Useful for excluding imprecisely estimated persons/legislators from the plot. Leave NULL if you don't want to exclude any.}

\item{group_overlap}{Whether to prevent the text from overlapping itself (ggplot2 option)}

\item{sample_persons}{If you don't want to use the full number of persons/legislators from the model, enter a proportion (between 0 and 1) to select
only a fraction of the persons/legislators.}

\item{...}{Other options passed on to plotting function, currently ignored}
}
\description{
This function can be used on a fitted \code{idealstan} object to plot the relative positions and 
uncertainties of legislator/persons and bills/items.
}
\details{
This plot shows the distribution of ideal points for the legislators/persons in the model. It will plot them as a vertical
dot plot with associated high-density posterior interval (10\% to 90\%). In addition, if the column index for a 
bill/item from the response matrix is passed to the \code{item_plot} option, then an item/bill midpoint will be overlain
on the ideal point plot, showing the point at which legislators/persons are indifferent to voting/answering on the 
bill/item. Note that because this is an ideal point model, it is not possible to tell from the midpoint itself
which side will be voting which way. For that reason, the legislators/persons are colored by their votes/scores to
make it clear.
}
\examples{

# To demonstrate, we load a fitted idealstan object based on the 114th Senate

data('senate114_fit')

id_plot_legis(senate114_fit)

# We can overlap the bill/item midpoints to show 
# where the persons/legislators are indifferent to responding positively

id_plot_legis(senate114_fit,item_plot=5)

}
