% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{ichimoku}
\alias{ichimoku}
\alias{ichimoku.ichimoku}
\alias{ichimoku.xts}
\alias{ichimoku.matrix}
\alias{ichimoku.data.frame}
\alias{ichimoku.default}
\title{ichimoku}
\usage{
ichimoku(x, ...)

\method{ichimoku}{ichimoku}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{xts}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{matrix}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{data.frame}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{default}(x, ticker, periods = c(9L, 26L, 52L), ...)
}
\arguments{
\item{x}{a data.frame or other compatible object, which includes xts,
data.table, tibble, and matrix.}

\item{...}{additional arguments, for instance 'holidays', passed along to
\code{\link{tradingDays}} for calculating the future cloud on daily data.}

\item{ticker}{(optional) specify a ticker to identify the instrument,
otherwise this is set to the name of the input object 'x'.}

\item{periods}{[default c(9L, 26L, 52L)] a vector defining the length of
periods used for the cloud. This parameter shoud not normally be modified
as using other values would be invalid in the context of traditional
Ichimoku analysis.}
}
\value{
An ichimoku object is returned with S3 classes of 'ichimoku', 'xts'
    and 'zoo'.

    This object contains a date-time index, OHLC pricing data, candle
    direction, the computed ichimoku cloud values, and cloud top and base
    values, with ticker, periods, and periodicity parameters set as
    attributes.
}
\description{
Create an ichimoku object containing the values for all components of the
    Ichimoku Kinko Hyo cloud chart, ready for visualization and quantitative
    analysis. The object includes a date-time index, OHLC pricing data,
    candle direction, the cloud lines Tenkan-sen, Kijun-sen, Senkou span A,
    Senkou span B and Chikou span, as well as values for the cloud top and
    base.
}
\details{
Calling an ichimoku object automatically invokes its print method,
    which will by default produce a printout of the data to the console as
    well as a static plot of the cloud chart to the graphical device.

    For further options, please use plot() on the returned ichimoku object to
    pass further arguments for customising the chart. Use iplot() for
    interactive charting.

    Where an ichimoku object is passed to ichimoku(), the ichimoku object is
    re-calculated using the OHLC pricing data contained within.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data)
ichimoku(sample_ohlc_data, ticker = "TKR", periods = c(9L, 26L, 52L))

}
