% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.ichimoku}
\title{autoplot.ichimoku}
\usage{
\method{autoplot}{ichimoku}(object, from, to, ticker, theme = "default", gaps = FALSE, ...)
}
\arguments{
\item{object}{an object of class 'ichimoku'.}

\item{from}{(optional) a starting date/time to subset the plot.}

\item{to}{(optional) an ending date/time to subset the plot.}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{theme}{with a default of 'default'. This can also be set to 'dark' or
'solarized' to select the desired colour scheme.}

\item{gaps}{set to FALSE by default to remove weekend and holiday gaps. Set
to TRUE for a continuous timescale axis, but with gaps for non-trading
days.}

\item{...}{other arguments to be passed along.}
}
\value{
Returns a ggplot2 object with S3 classes 'gg' and 'ggplot'.
}
\description{
Plot static Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function autoplot()
    for class 'ichimoku'. It can be invoked by calling autoplot(x) on an
    object 'x' of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

autoplot(cloud)
autoplot(cloud, from = "2020-05-15", to = "2020-10-30", theme = "dark")
autoplot(cloud, ticker = "TKR Co.", theme = "solarized", gaps = TRUE)

}
