% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_csquare.R
\name{get_csquare}
\alias{get_csquare}
\title{Download C-square information}
\usage{
get_csquare(c_square, stat_rec, ices_area, ecoregion, convert2sf = FALSE)
}
\arguments{
\item{c_square}{character 0.05 degree c-square name}

\item{stat_rec}{ICES statistical rectangle}

\item{ices_area}{ICES area}

\item{ecoregion}{ICES ecoregion}

\item{convert2sf}{logical, default FALSE, should an simple features object
be returned if the \code{sf} package is installed?}
}
\value{
a data.frame of VMS data
}
\description{
Download a data.frame of information on a set of C-squares.
}
\details{
If the \code{sf} package is installed then a simple features object
will be returned, if convert2sf flag is set to TRUE.
}
\examples{
\donttest{
sq40F3 <- get_csquare(stat_rec = "40F3")

# if the sf package is installed, an simple feature object will be returned
 NS <- get_csquare(ecoregion = "Greater North Sea", convert2sf = TRUE)
 plot(NS["ices_area"], border = "transparent")
}
}
