#' @docType package
#'
#' @name icesTAF-package
#'
#' @aliases icesTAF
#'
#' @title Functions to Support the ICES Transparent Assessment Framework
#'
#' @description
#' Functions to support the ICES Transparent Assessment Framework, to organize
#' data, methods, and results used in ICES assessments.
#'
#' @details
#' \emph{Initial TAF steps:}
#' \tabular{ll}{
#'   \code{\link{draft.data.script}} \tab create boot script\cr
#'   \code{\link{taf.roxygenise}}    \tab create DATA.bib entry from tags
#' }
#'
#' @author Colin Millar and Arni Magnusson.
#'
#' @references
#' ICES Transparent Assessment Framework: \url{https://taf.ices.dk}.
#'
#' To explore example TAF stock assessments, see the introductory
#' \href{https://www.youtube.com/watch?v=FweJbr9hfdY}{video} and
#' \href{https://github.com/ices-taf/doc/blob/master/tutorial-1/README.md}{tutorial}.
#'
#' The \href{https://github.com/ices-taf/doc/wiki}{TAF Wiki} provides additional
#' help resources.

NA
