% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.software.R
\name{draft.software}
\alias{draft.software}
\title{Draft SOFTWARE.bib}
\usage{
draft.software(package, version = NULL, source = NULL, file = "")
}
\arguments{
\item{package}{name of an installed R package.}

\item{version}{optional string to specify details about the version, e.g.
GitHub branch and commit date.}

\item{source}{optional string to specify where the software can be accessed.
This can be a GitHub reference of the form
\verb{owner/repo[/subdir]@ref}, URL, or a filename.}

\item{file}{optional filename to save the draft metadata to a file.}
}
\value{
Object of class \verb{Bibtex} that can be copied from the console or exported
to file using \code{writeLines}.
}
\description{
Create an initial draft version of a \file{SOFTWARE.bib} metadata file.
}
\details{
Typical usage is to specify \code{package}, while using the default values
for the other arguments.

With the default \verb{version = NULL}, the function will automatically
suggest an appropriate version entry for CRAN packages, but for GitHub
packages it is left to the user to add further information about the GitHub
branch (if different from \verb{master}) and the commit date.

With the default \verb{source = NULL}, the function will automatically
suggest an appropriate source entry for CRAN and GitHub packages, but for
other packages it is left to the user to add further information about where
the software can be accessed.

The default value \code{file = ""} prints the initial draft in the console,
instead of writing it to a file. The output can then be pasted into a file to
edit further, without accidentally overwriting an existing metadata file.
}
\note{
After creating the initial draft, the user can complete the \verb{version}
and \verb{source} fields as required.

This function only handles R packages. To prepare metadata for other
software, see the \code{\link{process.bib}} help page for an example.
}
\examples{
# Print in console
draft.software("icesTAF")

\dontrun{
# Export to file
draft.software("icesTAF", file="bootstrap/SOFTWARE-draft.bib")
}

}
\seealso{
\code{\link{citation}} and \code{\link{packageDescription}} are the
underlying functions to access information about installed R packages.

\code{\link{draft.data}} creates an initial draft version of a
\file{DATA.bib} metadata file.

\code{\link{process.bib}} reads and processes metadata entries.

\code{\link{icesTAF-package}} gives an overview of the package.
}
