% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationFunctions.R
\name{simCS_weib}
\alias{simCS_weib}
\title{Simulate Current Status Data}
\usage{
simCS_weib(n = 100, b1 = 0.5, b2 = -0.5, model = "ph", shape = 2,
  scale = 2)
}
\arguments{
\item{n}{Number of observations}

\item{b1}{Regression coefficient 1}

\item{b2}{Regression coefficient 2}

\item{model}{Regression model to use. Choices are \code{"ph"}, \code{"po"} or \code{"aft"}}

\item{shape}{Baseline shape parameter}

\item{scale}{Baseline scale parameter}
}
\description{
Simulates current status data from a survival regression model 
with a Weibull baseline distribution.
}
\details{
Exact event times are simulated according to the given survival regression model.
Two covariates are used; \code{x1 = rnorm(n), x2 = 1 - 2 * rbinom(n, 1, .5)}. After
event times are simulated, current status inspection times are simulated following the 
exact same conditional distribution as event time (so each event time necessarily has 
probability 0.5 of being right censored).
}
\examples{
simData <- simCS_weib()
fit <- ic_par(cbind(l, u) ~ x1 + x2, data = simData)
}

