\name{simIC_weib}
\alias{simIC_weib}
\title{Simulates interval censored data from regression model with a Weibull baseline}
\usage{
  simIC_weib(n = 100, b1 = 0.5, b2 = -0.5, model = "ph", shape = 2, 
    scale = 2, inspections = 2, inspectLength = 2.5, rndDigits = NULL)
}
\arguments{
  \item{n}{Number of samples simulated}
  \item{b1}{Value of first regression coefficient}
  \item{b2}{Value of second regression coefficient}
  \item{model}{Type of regression model. Options are 'po' (prop. odds) and 'ph' (Cox PH)}
  \item{shape}{shape parameter of baseline distribution}
  \item{scale}{scale parameter of baseline distribution}
  \item{inspections}{number of inspections times of censoring process}
  \item{inspectLength}{max length of inspection interval}
  \item{rndDigits}{number of digits to which the inspection time is rounded to, creating a discrete inspection time. If \code{rndDigits = NULL}, the inspection time is not rounded, resulting in a continuous inspection time}
}
\description{
  Simulates interval censored data from a regression model with a weibull baseline distribution. Used for demonstration
  }
\details{
	Exact event times are simulated according to regression model: covariate \code{x1} is distributed \code{rnorm(n)} and covariate \code{x2} is distributed \code{1 - 2 * rbinom(n, 1, 0.5)}. Event times are then censored with a case II interval censoring mechanism with \code{inspections} different inspection times. Time between inspections is distributed as \code{runif(min = 0, max = inspectLength)}. Note that the user should be careful in simulation studies not to simulate data where nearly all the data is right censored (or more over, all the data with x2 = 1 or -1) or this can result in degenerate solutions!
}

\examples{
	#Not run: takes about 20 seconds to run
	#sim_data <- simIC_weib(n = 2000, b1 = .3, b2 = -.3, model = 'ph', 
	#                       shape = 5, scale = 1, inspections = 6, inspectLength = 1)
	#simulates data from a cox-ph with beta weibull distribution.
	
	#diag_covar(Surv(l, u, type = 'interval2') ~ x1 + x2, data = sim_data, model = 'po')
	#diag_covar(Surv(l, u, type = 'interval2') ~ x1 + x2, data = sim_data, model = 'ph')
	#'ph' fit looks better than 'po'; the difference between the transformed survival
	#function looks more constant
}	
\author{
  Clifford Anderson-Bergman
}