% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-comorbid.R
\name{parseElix}
\alias{parseElix}
\title{Generate Elixhauser comorbidities}
\usage{
parseElix(condense = FALSE, save = FALSE, path = "data")
}
\arguments{
\item{condense}{logical whether to condense the result ranges to the minimal
set of parent ICD-9 codes which exactly define the list. Defaults to
\code{FALSE} so that the saved list will allow rapid look-up of codes
without further processing. Small memory versus time trade-off.}

\item{save}{logical whether to save the result in the source tree. Defaults
to \code{FALSE}.}

\item{path}{path to directory to save the data. This is typically the data
folder in the devleopment source tree. Defaults to \code{"~/icd9/data"}.
Could possibly avoid hard-coding path with devtools functions.}
}
\value{
invisibly returns the list of vectors, where a
  co-morbidity name is associated with a character vector of ICD-9 codes.
}
\description{
This function uses the \code{\%i9d\%} operator, so cannot be
  done as an R file in the \code{data} directory. The data is documented in
  \code{datadocs.R}.
}
\keyword{internal}

