% Generated by roxygen2 (4.0.1): do not edit by hand
\name{parseAhrqSas}
\alias{parseAhrqSas}
\title{parse AHRQ data}
\usage{
parseAhrqSas(sasPath = system.file("extdata", "comformat2012-2013.txt",
  package = "icd9"), condense = FALSE, save = FALSE, path = "~/icd9/data",
  returnAll = FALSE)
}
\arguments{
\item{sasPath}{single character string containing path or URL for some SAS
code. The source SAS code is stored in extdata or at the location specified
in URL. In development mode in \code{devtools}, this is actually
inst/extdata. This function is internal, since it is used to generate data
which ends up in the distributed package. However, the package user can
verify that the code creates the distributed R data. Also, changes to the
original SAS code can be used to regenerate the R data by the user, without
waiting for a package release.}

\item{condense}{logical whether to condense the result ranges to the minimal
set of parent ICD-9 codes which exactly define the list. Defaults to
\code{FALSE} so that the saved list will allow rapid look-up of codes
without further processing. Small memory versus time trade-off.}

\item{save}{logical whether to save the result in the source tree. Defaults
to \code{FALSE}.}

\item{path}{path to directory to save the data. This is typically the data
folder in the devleopment source tree. Defaults to \code{"~/icd9/data"}.
Could possibly avoid hard-coding path with devtools functions.}

\item{returnAll}{logical which, if TRUE, will result in the invisible return of ahrqComorbidAll result, otherwise, ahrqComorbid is reutrned.}
}
\value{
invisibly returns the list of vectors, where a
  co-morbidity name is associated with a character vector of ICD-9 codes.
}
\description{
Takes the raw data taken directly from the AHRQ web site and
  parses into RData. It is then saved in the development tree data directory,
  so this is an internal function, used in generating the package itself!
}
\keyword{internal}

